<?php
/**
 * Ajax Functions
 *
 * @package     AutomatorWP\SureCart\Ajax_Functions
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Ajax function for selecting contents
 *
 * @since 1.0.0
 */
function automatorwp_surecart_ajax_get_products() {
    // Security check, forces to die if not security passed
    check_ajax_referer( 'automatorwp_admin', 'nonce' );

    global $wpdb;

    // Pull back the search string
    $search = isset( $_REQUEST['q'] ) ? $wpdb->esc_like( sanitize_text_field( $_REQUEST['q'] ) ) : '';

    $products = automatorwp_surecart_get_products();

    // Parse product results to match select2 results
    foreach ( $products as $product ) {

        if( ! empty( $search ) ) {
            if( strpos( strtolower( $product['name'] ), strtolower( $search ) ) === false ) {
                continue;
            }
        }
        
        $results[] = array(
            'id' => $product['id'],
            'text' => $product['name']
        );
    }

    // Prepend option none
    $results = automatorwp_ajax_parse_extra_options( $results );

    // Return our results
    wp_send_json_success( $results );
    die;

}
add_action( 'wp_ajax_automatorwp_surecart_get_products', 'automatorwp_surecart_ajax_get_products' );